create or replace function alterview() 
returns void as 
$body$ 
declare
	msgfinal text := 'alterada';
begin 
if exists (select 1 from information_schema.columns where table_name= 'v_maparesumo') then 
	drop view v_maparesumo;
    raise notice 'visão v_maparesumo foi removida';                             
end if; 

if exists (select 1 from information_schema.columns where table_name= 'v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz') then 
	drop view v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz;
    raise notice 'visão v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz foi removida';                             
end if; 

if exists (select 1 from information_schema.columns where table_name ilike 'pdv_mapa_resumo' and column_name ilike 'vlr_vend_bruta') then
	alter table pdv_mapa_resumo alter column vlr_vend_bruta type numeric(30,4);
	 raise notice 'coluna vlr_vend_bruta alterada!';
end if;

if exists (select 1 from information_schema.columns where table_name ilike 'pdv_mapa_resumo' and column_name ilike 'vlr_base_calc_efet') then
	alter table pdv_mapa_resumo alter column vlr_base_calc_efet type numeric(30,4);
	raise notice 'coluna vlr_base_calc_efet alterada!';
end if;

--criação da view v_maparesumo
create or replace view public.v_maparesumo
as select resumo.cd_emp,
    resumo.cd_filial,
    null::integer as cd_ctr,
    resumo.dt_ecf,
    resumo.cd_cx,
    0 as st_vd,
    resumo.dt_cad,
    resumo.dt_cad::date + resumo.hr_cad::time without time zone as hr_cad,
    resumo.cont_red_z,
    resumo.cont_ord_op_ini,
    resumo.cont_ord_op_fin,
    resumo.cont_reinicio_op,
    resumo.vlr_gt_ini,
    resumo.vlr_gt_fin,
    resumo.vlr_vend_bruta,
    resumo.vlr_desc,
    resumo.vlr_canc,
    resumo.vlr_contab,
    resumo.vlr_icms,
    resumo.vlr_isentas,
    resumo.vlr_n_trib,
    resumo.vlr_base_icms_subs,
    resumo.vlr_issqn,
    resumo.vlr_desc_issqn,
    resumo.vlr_cancel_issqn,
    aliquotas.tx_icms,
    aliquotas.base_calc,
    coalesce(aliquotas.tipo_imposto, 0::numeric) as tipo_imposto,
    round(aliquotas.base_calc * aliquotas.tx_icms / 100::numeric, 2) as vlr_tx_icms,
    coalesce(resumo.flag_consolidado, 0) as flag_consolidado
   from pdv_mapa_resumo resumo
     left join pdv_mapa_resumo_cpl aliquotas on resumo.cd_emp = aliquotas.cd_emp and resumo.cd_filial = aliquotas.cd_filial and resumo.dt_ecf = aliquotas.dt_ecf and resumo.cd_cx = aliquotas.cd_cx;
   raise notice 'criada v_maparesumo';
-- permissions
alter table public.v_maparesumo owner to postgres;
grant all on table public.v_maparesumo to postgres;

-- criação da view v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz
create or replace view public.v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz
as select mp.cd_emp,
    mp.cd_filial,
    mp.cd_cx,
    mp.dt_ecf,
    mp.cont_red_z,
    mp.coo_reducao_z,
    mp.cont_reinicio_op,
    mp.dt_cad,
    mp.hr_cad,
    mp.vlr_vend_bruta,
    mp.vlr_gt_fin,
    mp.vlr_base_icms_subs,
    mp.vlr_isentas,
    mp.vlr_n_trib,
    mp.vlr_desc,
    mp.vlr_canc,
    mp.dt_usuario_ecf,
    mp.dt_usuario_software_basico,
    mp.letra_mf_adicional,
    mp.nr_serie_imp,
    ( select pdv_cx.modelo_ecf
           from pdv_cx
          where mp.cd_emp = pdv_cx.cd_emp and mp.cd_filial = pdv_cx.cd_filial and mp.cd_cx = pdv_cx.cd_cx) as modelo_ecf,
        case
            when coalesce(mp.reg_alterado, 0) = 1 then 1
            else 0
        end as reg_alterado
   from pdv_mapa_resumo mp;
    raise notice 'criada v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz';

-- permissions
alter table public.v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz owner to postgres;
grant all on table public.v_pdv_menu_fiscal_movimento_ecf_dados_reducaoz to postgres;

end; 
-- fim bloco principal 
$body$ 
language plpgsql volatile 
  cost 100; 
alter function alterview() owner to postgres; 
select alterview(); 
drop function alterview();

